﻿/*----------------------------------------------------------------
 文件名：mainControl.js
 文件功能描述：地图标记拖拽实现
 ----------------------------------------------------------------*/
var marker_drag = (function($){
    var mk = null;//拖拽的标记
    var callback = null;//回调函数
    var px = null;//进入时候的像素点
    var mp = null;//地图对象
    var draged = false;//是否被拖拽
    return {
        /**
         * 开始拖拽
         * @param	marker		需要拖拽的标记对象
         * @param 	e			系统触发事件
         * @param 	mapObj 		地图对象
         * @param	startCall	开始拖拽前执行函数
         * @param	dragCall	拖拽过程中执行函数
         * @param 	stopCall	拖拽完成时执行函数
         * @author	jquan_zhang
         */
        start: function(marker, e, mapObj, startCall, dragCall, stopCall){
            if (!marker || !mapObj) 
                return;
            if (!marker.map) 
                marker.map = mapObj;
            mk = marker;
            mp = mapObj;
            callback = {
                startCall: startCall,
                dragCall: dragCall,
                stopCall: stopCall
            }
            px = mp.getLayerPxFromLonLat(mk.lonlat);
            document.onmousemove = marker_drag.drag;
            document.onmouseup = marker_drag.stop;
        },
        /**
         * 拖拽过程
         * @param 	e			系统触发事件
         * @author	jquan_zhang
         */
        drag: function(e){
            if (!draged) {
                draged = true;
                if (callback.startCall) 
                    callback.startCall.call(this, e);
            }
            var ev = e || window.event;
            var pos = marker_drag.mouseCoords(ev);
            mk.moveTo(mp.getLayerPxFromViewPortPx(new OpenLayers.Pixel(pos.x - $(mp.div).offset().left, pos.y + mk.icon.size.h / 2 - $(mp.div).offset().top)));
            var testLonlat = new OpenLayers.LonLat(mk.lonlat.lon, mk.lonlat.lat + mk.icon.size.h/2);
            if (!mp.baseLayer.extent.containsLonLat(testLonlat, false)){
            	marker_drag.stop();
            }
            if (callback.dragCall) 
            callback.dragCall.call(this, e);
        },
        /**
         * 拖拽完成
         * @param 	e			系统触发事件
         * @author	jquan_zhang
         */
        stop: function(e){
            document.onmousemove = null;
            document.onmouseup = null;
            draged = false;
            var testLonlat = new OpenLayers.LonLat(mk.lonlat.lon, mk.lonlat.lat + mk.icon.size.h/2);
            if (!mp.baseLayer.extent.containsLonLat(testLonlat, false)) {
                var stopPx = mp.getLayerPxFromLonLat(mk.lonlat);
                var xCut = (px.x - stopPx.x) / 50;
                var yCut = (px.y - stopPx.y) / 50;
                var tempPos = {
                    x: stopPx.x,
                    y: stopPx.y
                };
                var i = 0;
                (function(mvMk,mvPx){
                	var revertInterVal = setInterval(function(){
                        tempPos.x += xCut;
                        tempPos.y += yCut;
                        i++;
                        mvMk.moveTo(new OpenLayers.Pixel(tempPos.x, tempPos.y));
                        if (i >= 50) {
                            clearInterval(revertInterVal);
                            mvMk.moveTo(mvPx);
                            if (callback.stopCall) 
                                callback.stopCall.call(this, e);
                        }
                    }, 10);
                })(mk,px)
            }
            else {
                if (callback.stopCall) 
                    callback.stopCall.call(this, e);
            }
        },
        /**
         * 获取鼠标点
         * @param 	ev			系统触发事件
         * @author	jquan_zhang
         */
        mouseCoords: function(ev){
            if (ev.pageX || ev.pageY) {
                return {
                    x: ev.pageX,
                    y: ev.pageY
                };
            }
            return {
                x: ev.clientX + document.body.scrollLeft - document.body.clientLeft,
                y: ev.clientY + document.body.scrollTop - document.body.clientTop
            };
        }
    };
})($);
